import axios from 'axios';
import moment from 'moment';

/**
 * 
 * Function to handle excessive failed logins and send to Superadmin for alert log
 */
export async function handleExcessiveFailedLogins(field) {
    console.log(`Excessive failed login attempts detected for field: ${field}`);

    // Example Payload for a hypothetical alert function (replace with your function call)
    const alertPayload = {
        field: field, // Email or Unique ID of the user with failed attempts
        timestamp: moment().format('YYYY-MM-DD HH:mm:ss'),
        eventType: "Excessive Failed Login Attempts",
        // Add any other relevant details you want to send in the alert
    };

    console.log("Payload for alert (example):", alertPayload);
    const authDataSendStatus = await sendAuthFailureReportToSuperadmin(alertPayload, process.env.SUPER_ADMIN_BACKEND_URL);
    if(authDataSendStatus.success) {
        return true;
    } else {
        return false;
    }
}

/**
    * Function to set up Auth failure for wrong password and send payload to superadmin
    * in the client service.
    * @param {string} superadminApiUrl - The URL of the superadmin service's crash report API endpoint.
    */
async function sendAuthFailureReportToSuperadmin(authLog, superadminApiUrl) {
    try {
        const formattedPayload = {
            clientId: 1, // Dynamically retrieve the client ID
            alertType: ["Authentication Failure"],
            alertSentDateTime: moment().format('YYYY-MM-DD HH:mm:ss'),
            deliveryStatus: "Pending",
            createdBy: 1, // Dynamically assign the user
            authLog: authLog
        };
        const fullUrl = `${superadminApiUrl}/api/notification-configuration-alert-log`;
        const response = await axios.post(fullUrl, formattedPayload);
        console.log('Client service: Auth Failure report successfully sent to superadmin service.',
            { data: response.data }
        );
        return { success: true };
    } catch (apiError) {
        console.error('Client service: Error sending Auth Failure report to superadmin service:', apiError.message);
        return { success: false, message: apiError.message, error: apiError?.response?.data || [] };
    }
}