import AWS from "aws-sdk";

class AWSUtil {
  constructor() {
    this.s3 = new AWS.S3({
      accessKeyId: process.env.AWS_ACCESS_KEY_ID,
      secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
      region: process.env.AWS_REGION,
    });
  }

  async uploadFile(file, folder, ACL = "public-read") {
    const params = {
      Bucket: AWS_S3_BUCKET,
      // Key: `${folder}/${nanoid()}.${file.originalname.split(".").pop()}`,
      Key: `${Date.now()}-${file.name}`,
      Body: file.data,
      ContentType: file.mimetype,
      ACL,
    };

    const data = await this.s3.upload(params).promise();

    return data.Location;
  }

  async deleteFile(Location) {
    const params = {
      Bucket: process.env.AWS_S3_BUCKET,
      Key: Location.split("s3.amazonaws.com/").pop(),
    };

    const data = await this.s3.deleteObject(params).promise();

    return data;
  }
}

export default new AWSUtil();
