import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import KnowledgeManagementRecording from "./knowledgeManagementRecordingsSchema.js";

const KnowledgeComment = sequelize.define(
  "KnowledgeComment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    knowledge_recording_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: KnowledgeManagementRecording,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    steps: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    reject_reason: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    comment_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("approved", "rejected"),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "knowledge_comment",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

KnowledgeComment.belongsTo(KnowledgeManagementRecording, {
  foreignKey: "knowledge_recording_id",
  as: "knowledge_recording",
});

KnowledgeComment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

KnowledgeComment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await KnowledgeComment.sync({ alter: true }));

export default KnowledgeComment;
