import { EndFields } from "../constants/constants.js";
import OperationalRisk from "./OperationalRiskSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes, Model } from "sequelize";

class WorkArea extends Model {}

WorkArea.init(
  {
    name: {
      type: DataTypes.STRING(250),
    },
    operational_risk_id: {
      type: DataTypes.INTEGER,
      references: {
        model: OperationalRisk,
        key: OperationalRisk.primaryKeyAttribute,
      },
    },
    ...EndFields,
  },
  {
    tableName: "operational_work_area",
    sequelize,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await WorkArea.sync({ alter: true }));
export default WorkArea;
