import { DataTypes, STRING } from "sequelize";
import sequelize from "./sequelize.js";
import TrainingSchedule from "./TrainingScheduleSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Currency from "./CurrencySchema.js";

const TrainingAttendance = sequelize.define(
  "TrainingAttendance",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    actual_training_service: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    attendees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    training_actual_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    training_actual_time: {
      type: DataTypes.TIME,
    },
    company: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    training_program: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TrainingSchedule,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    training_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    training_total_cost: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    training_venue: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    upload_document: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employee: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    group_name: {
      type: DataTypes.STRING(255),
    },
    external_provider: {
      type: DataTypes.STRING(255),
    },
    currency: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Currency,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    role_name: {
      type: DataTypes.STRING(255),
    },
    provider_department: {
      type: DataTypes.STRING(255),
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,
    tableName: "attendance_recording",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TrainingAttendance.belongsTo(TrainingSchedule, {
  foreignKey: "training_program",
  as: "TrainingSchedule",
});

TrainingAttendance.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

TrainingAttendance.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

TrainingAttendance.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TrainingAttendance.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

// console.log(await TrainingAttendance.sync({ alter: true }))

export default TrainingAttendance;
