import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";

const SurveyDesign = sequelize.define(
  "SurveyDesign",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: null,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      defaultValue: null,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    survey_analysis: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      defaultValue: null,
    },
    is_automated: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    is_responded: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    public_url: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 1,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "survey_design",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SurveyDesign.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

SurveyDesign.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

// console.log(await SurveyDesign.sync({alter : true}))

export default SurveyDesign;
