import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import StakeHolderClassification from "./StakeholderClassificationSchema.js";

const StakeHolderIdentification = sequelize.define(
  "StakeHolderIdentification",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    classification_type: {
      type: DataTypes.STRING(255),
    },
    priority_level: {
      type: DataTypes.STRING(255),
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    stakeholder_category: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: StakeHolderClassification,
        key: "id",
      },
    },
    internal_stakeholder: {
      type: DataTypes.TEXT("long"),
    },
    external_stakeholder: {
      type: DataTypes.TEXT("long"),
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,
    tableName: "stakeholder_identification",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

StakeHolderIdentification.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

StakeHolderIdentification.belongsTo(Department, {
  foreignKey: "department",
  as: "ExternalDepartment",
});

StakeHolderIdentification.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

StakeHolderIdentification.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

// console.log(await StakeHolderIdentification.sync({ alter: true }));                                                                                                                                                                                                                                          
export default StakeHolderIdentification;
