import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import StakeholderActivityRecording from "./StakeholderActivityRecordingSchema.js";
import User from "./UserSchema.js";
// import { allow } from "joi";

export const StakeholderActivityNotes = sequelize.define(
  "StakeholderActivityNotes",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    activity_recording_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: StakeholderActivityRecording,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    agenda_item: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    raised_by: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    activity_discussion_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    activity_discussion_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    activity_action_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    activity_action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assigned_to: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    due_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    activity_action_progress: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "activity_notes",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

StakeholderActivityNotes.belongsTo(StakeholderActivityRecording, {
  foreignKey: "activity_recording_id",
  as: "StakeholderActivityRecording",
});

StakeholderActivityNotes.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

StakeholderActivityNotes.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default StakeholderActivityNotes;
