import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";

const SafetyIncident = sequelize.define(
  "SafetyIncident",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    type_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    location: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    immediate_cause_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    was_alcohol_or_substance_testing_done: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    tested_by: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    state_name: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    alcohol_substance_test_results: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    method_of_testing: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_the_person_or_operator_licensed: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    was_the_license_applicable_to_the_task: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
    },
    license_training_expiry_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    license_no_training_certificate_no: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    year_issued: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    issued_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_level: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reportable_cases_classification: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_the_case_reported_to_authority: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: 0,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    form_completed_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    designation: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },

  {
    tableName: "safety_incident",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SafetyIncident.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

SafetyIncident.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

SafetyIncident.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default SafetyIncident;
