import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";
import DocumentCreation from "./DocumentCreationSchema.js";

const Repository = sequelize.define(
  "repository",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    url: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    size: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    type: {
      type: DataTypes.ENUM("folder", "file"), // folder , file
      allowNull: true,
      defaultValue: "folder",
    },
    parent_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    document_creation_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: DocumentCreation,
        key: "id",
      },
    },
    table_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    table_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    sidebar_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    is_locked: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    is_archived: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    ...EndFields,
  },
  {
    tableName: "repository",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await Repository.sync({ alter: true }));

export default Repository;
