import ContractorForms from "./ContractorFormSchema.js";
import ContractorQuestionnaire from "./ContractorQuestionnaireSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";

const QuestionnaireResponses = sequelize.define(
  "QuestionnaireResponses",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    value: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employee_email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Response Pending",
    },
    contractor_ques_form: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorForms,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    reciept_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    comment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    endorsement_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    contractor_questionnaire_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorQuestionnaire,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "CASCADE",
    },
  },
  {
    timestamps: false,

    tableName: "questionnaire_response",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// console.log(await QuestionnaireResponses.sync({ alter: true }));

export default QuestionnaireResponses;
