import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import CategoryType from "./CategoryTypeSchema.js";
import Incident from "./IncidentSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import Category from "./CategorySchema.js";
const OccupationalDiseaseForm = sequelize.define(
  "OccupationalDiseaseForm",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Category,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_id: {
      //? auto-fetch
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    incident_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_time: {
      type: DataTypes.TIME(6),
      allowNull: true,
    },
    incident_severity: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    specify: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    initial_incident_severity: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    name_of_exposed_person: {
      type: DataTypes.INTEGER, //?employee_id
      allowNull: true,
    },
    role: {
      //? id auto-fetch from table
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    applicable_license: {
      type: DataTypes.ENUM("Yes", "No"),
      allowNull: true,
      defaultValue: "No",
    },
    license_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    license_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    license_expiry_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    applicable_training: {
      type: DataTypes.ENUM("Yes", "No"),
      allowNull: true,
      defaultValue: "No",
    },
    training_certificate_number: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_certificate_expiry_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    _they_licensed_trained: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    was_license_training_applicable_to_task: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    license_training_expiry_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    license_no_training_certificate_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    year_issued: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    issued_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    occupational_disease_category: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    occupational_disease: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    occupational_disease_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    occupational_disease_severity_level: {
      type: DataTypes.INTEGER, //? severity_id
      allowNull: true,
    },
    noise_induced_hearing_loss: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_diagnosis: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    was_case_reported_to_authority_regulator: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    name_of_regulator: {
      type: DataTypes.INTEGER, //? regulator_id
      allowNull: true,
    },
    date_reported: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    reported_by_who: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    effect_on_person: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    exposure_route: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    source_of_exposure: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    estimated_duration_of_exposure: {
      type: DataTypes.TIME(6),
      allowNull: true,
    },
    other_employees_exposed: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    names_of_exposed_employees: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    occupational_hygiene_survey_conducted: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    occupational_hygiene_survey_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    occupational_hygiene_survey_finish_date: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    occupational_hygiene_survey_confirmed: {
      type: DataTypes.ENUM("yes", "no"),
      allowNull: true,
      defaultValue: "no",
    },
    occupational_hygiene_report_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    occupational_hygiene_report_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    estimated_cost_medical_expenses: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    form_completed_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    designation: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    signature: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    occupationals: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,
    tableName: "occupational_disease_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
OccupationalDiseaseForm.belongsTo(Category, {
  foreignKey: "category_id",
  as: "CategoryType",
});
OccupationalDiseaseForm.belongsTo(Incident, {
  foreignKey: "incident_id",
  as: "Incident",
});
OccupationalDiseaseForm.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

OccupationalDiseaseForm.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
OccupationalDiseaseForm.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await OccupationalDiseaseForm.sync({ alter: true }));
export default OccupationalDiseaseForm;
