import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import IncidentCategory from "./IncidentCategorySchema.js";

const HazmatFireTechnical = sequelize.define(
  "HazmatFireTechnical",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: IncidentCategory,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    table_data: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    type_of_occurrence: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    alcohol_testing: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    substance_testing: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    none_testing: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    state_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tested_by_employee: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    specify_tested_by_who: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    // hazmat: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    // fire: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    location_of_occurrence: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_occurrence: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    time_of_occurrence: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    occurrence_ref_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    immediate_cause_of_occurrence: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // involved_employee_details_name
    // tested_by_who
    // reported_by_who
    involved_employee_details_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    involved_employee_details_employee_sap: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    involved_employee_details_employee_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    involved_employee_details_experience: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    involved_employee_details_role: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_alcohol_or_substance_testing_done: {
      type: DataTypes.STRING(3),
      allowNull: true,
    },
    select_substance_testing: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    tested_by_who: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tested_by_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    substance_test_results: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    method_of_testing: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    specify_method_of_testing: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_person_or_operator_licensed_trained: {
      type: DataTypes.STRING(3),
      allowNull: true,
    },
    was_license_training_applicable_to_task: {
      type: DataTypes.STRING(3),
      allowNull: true,
    },
    license_training_expiry_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    license_no_training_certificate_no: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    year_issued: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    issued_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    occurrence_level: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_case_reported_to_authority_regulator: {
      type: DataTypes.STRING(3),
      allowNull: true,
    },
    name_of_authority: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_reported_to_authority: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    reported_by_who: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    estimated_cost_medical_expenses: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    form_completed_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    designation: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    signature: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    tested_is_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    tested_contractor_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    tested_project_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0,
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "hazmat_fire_technical_form",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

HazmatFireTechnical.belongsTo(Incident, {
  foreignKey: "incident_id",
  as: "Incident",
});

HazmatFireTechnical.belongsTo(User, {
  foreignKey: "involved_employee_details_name",
  as: "InvolvedEmployee",
});
HazmatFireTechnical.belongsTo(User, {
  foreignKey: "reported_by_who",
  as: "ReportedByUser",
});
HazmatFireTechnical.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
HazmatFireTechnical.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
HazmatFireTechnical.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
HazmatFireTechnical.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
// console.log(await HazmatFireTechnical.sync({ alter: true }));

export default HazmatFireTechnical;
