import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import Incident from "./IncidentSchema.js";
import IncidentCategory from "./IncidentCategorySchema.js";

const ExplosionBombForm = sequelize.define(
  "ExplosionBombForm",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    category_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: IncidentCategory,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    tested_is_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    tested_contractor_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    tested_project_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    specify_method_of_testing: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    type_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    immediate_cause_of_incident: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    was_alcohol_or_substance_testing_done: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    alcohol_testing: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    substance_testing: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    none: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tested_by: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    tested_by_employee: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    state_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    specify: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    alcohol_substance_test_results: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    method_of_testing: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_the_person_or_operator_licensed: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    was_the_license_applicable_to_the_task: {
      type: DataTypes.TINYINT,
      allowNull: true,
    },
    license_training_expiry_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    license_no_training_certificate_no: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    year_issued: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    issued_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_level: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    reportable_cases_classification: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    was_the_case_reported_to_authority: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
    name_of_regulator: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    date_reported: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    reported_by: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    estimated_cost: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    form_completed_by: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    designation: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    signature: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
      allowNull: true,
    },
  },
  {
    tableName: "explosion_bomb_form",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ExplosionBombForm.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ExplosionBombForm.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ExplosionBombForm.belongsTo(Incident, {
  foreignKey: "incident_id",
  as: "Incident",
});

ExplosionBombForm.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
ExplosionBombForm.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});
// console.log(await ExplosionBombForm.sync({ alter: true }));

export default ExplosionBombForm;
