import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Department from "./DepartmentSchema.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";

const EvidenceGathering = sequelize.define(
  "EvidenceGathering",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    date_collection: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    time_of_collection: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    type_of_evidence: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    source_of_evidence: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    upload_evidence_file: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    serial_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    upload_barcode: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    physical_evidence_description: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    policy_and_procedure_documents: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    record_retention_policies: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    regulatory_guidance: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    other_documents: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    evidence_preservation: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    chain_of_custody: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "evidence_gathering",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

EvidenceGathering.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
EvidenceGathering.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
EvidenceGathering.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});
EvidenceGathering.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

export default EvidenceGathering;
