import Regulator from "./RegulatorSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes, Model } from "sequelize";
import User from "./UserSchema.js";
import { EndFields } from "../constants/constants.js";
import Organization from "./OrganizationSchema.js";
import IncidentCategory from "./IncidentCategorySchema.js";

class EnvironmentalIncident extends Model {}

EnvironmentalIncident.init(
  {
    category_id: {
      type: DataTypes.INTEGER,
      // references : IncidentCategory
    },
    incident_id: {
      type: DataTypes.INTEGER,
    },
    save_type: {
      type: DataTypes.STRING(255),
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    incident_title: {
      type: DataTypes.STRING(255),
    },
    incident_date: {
      type: DataTypes.DATE,
    },
    incident_time: {
      type: DataTypes.TIME,
    },
    incident_severity: {
      type: DataTypes.STRING(255),
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
    },
    incident_location: {
      type: DataTypes.TEXT("long"),
    },
    incident_type: {
      type: DataTypes.JSON,
    },
    technical_form_completed_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: User.primaryKeyAttribute,
      },
    },
    role_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    date_of_submission: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    notification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // incident_type_details: {
    //   type: DataTypes.JSON,
    // },
    // environmental_incident_description: {
    //   type: DataTypes.STRING(255),
    // },
    // environmental_incident_severity_level: {
    //   type: DataTypes.ENUM(
    //     "Level 1 - Catastrophic",
    //     "Level 2 - Critical",
    //     "Level 3 - Moderate",
    //     "Level 4 - Minor"
    //   ),
    // },
    // reported_to_authorities: {
    //   type: DataTypes.BOOLEAN,
    //   defaultValue: 0,
    // },
    // regulator_name: {
    //   type: DataTypes.INTEGER,
    //   references: {
    //     model: Regulator,
    //     key: Regulator.primaryKeyAttribute,
    //   },
    // },
    // date_reported: {
    //   type: DataTypes.DATE,
    // },
    // reported_by: {
    //   type: DataTypes.INTEGER,
    //   model: {
    //     model: User,
    //     key: User.primaryKeyAttribute,
    //   },
    // },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    department: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "users",
        key: "id",
      },
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "users",
        key: "id",
      },
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    modelName: "EnvironmentalIncident",
    tableName: "environmental_incidents",
    sequelize,
    timestamps: false,
    paranoid: true,
    underscored: true,
  }
);

// console.log(await EnvironmentalIncident.sync({ alter: true }));

export default EnvironmentalIncident;
