import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import QuestionnaireResponses from "./QuestionnaireResponsesSchema.js";

const ContractorQuestionnaireDocs = sequelize.define(
  "ContractorQuestionnaireDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    questionnaire_response_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: QuestionnaireResponses,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_questionnaire_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

export default ContractorQuestionnaireDocs;
