import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Department from "./DepartmentSchema.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";

const ContractorPreSite = sequelize.define(
  "ContractorPreSite",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    total: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    responses: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "contractor_pre_site",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorPreSite.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "Contractor",
});
ContractorPreSite.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});
ContractorPreSite.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});
ContractorPreSite.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
ContractorPreSite.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await ContractorPreSite.sync({ alter: true }));
export default ContractorPreSite;
