import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import DocumentType from "./DocumentTypeSchema.js";
import ContractorAuditProtocol from "./ContractorAuditProtocolSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import Repository from "./RepositorySchema.js";

const ContractorDocumentRepository = sequelize.define(
  "ContractorDocumentRepository",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    document_type: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: DocumentType,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    associated_audit: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorAuditProtocol,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    document_name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    document_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // document_path: {
    //   type: DataTypes.STRING(500),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    allowed_access_to: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    audit_execution_id: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "contractor_document_repository",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// Associations
// Associations
ContractorDocumentRepository.belongsTo(DocumentType, {
  foreignKey: "document_type",
  as: "documentType",
});

ContractorDocumentRepository.belongsTo(ContractorAuditProtocol, {
  foreignKey: "associated_audit",
  as: "auditProtocol",
});

ContractorDocumentRepository.belongsTo(Organization, {
  foreignKey: "organization",
  as: "org",
});

ContractorDocumentRepository.belongsTo(Department, {
  foreignKey: "department",
  as: "dep",
});

ContractorDocumentRepository.belongsTo(User, {
  foreignKey: "created_by",
  as: "creator",
});

ContractorDocumentRepository.belongsTo(User, {
  foreignKey: "updated_by",
  as: "updater",
});

// console.log(await ContractorDocumentRepository.sync({ alter: true }));
export default ContractorDocumentRepository;
