import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import ContractorAuditScheduling from "./ContractorAuditSchedulingSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";

const ContractorAuditProtocol = sequelize.define(
  "ContractorAuditProtocol",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    scheduled_audit: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorAuditScheduling,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    actual_audit_start_date_time: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    actual_audit_end_date_time: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    audit_protocol: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    audit_protocol_id: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "contractor_audit_protocol",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorAuditProtocol.belongsTo(ContractorAuditScheduling, {
  as: "scheduledAudit",
  foreignKey: "scheduled_audit",
});

ContractorAuditProtocol.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});

ContractorAuditProtocol.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});

ContractorAuditProtocol.belongsTo(User, {
  as: "createdBy",
  foreignKey: "created_by",
});

ContractorAuditProtocol.belongsTo(User, {
  as: "updatedBy",
  foreignKey: "updated_by",
});

export default ContractorAuditProtocol;
