import { DataTypes, Op } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Region from "./RegionSchema.js";
import State from "./StateSchema.js";
import * as XLSX from "xlsx";
import fs from "fs";

const City = sequelize.define(
  "City",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    state_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    state_code: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    country_id: {
      type: DataTypes.INTEGER.UNSIGNED,
      allowNull: true,
    },
    country_code: {
      type: DataTypes.CHAR(2),
      allowNull: true,
    },
    latitude: {
      type: DataTypes.DECIMAL(10, 8),
      allowNull: true,
    },
    longitude: {
      type: DataTypes.DECIMAL(11, 8),
      allowNull: true,
    },
    region_id: {
      type: DataTypes.INTEGER,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: "2014-01-01 06:31:01",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    flag: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: true,
    },
    wikiDataId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      comment: "Rapid API GeoDB Cities",
    },
  },
  {
    tableName: "cities",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_unicode_ci",
    rowFormat: "COMPACT",
  }
);
// await City.sync({ alter: true });
export default City;
// Read the Excel file
// const filePath =
//   '/Users/DELL/Desktop/ssheq-and-grc-mngmt-platform/api/police.xlsx';
// const file = fs.readFileSync(filePath);
// const workbook = XLSX.read(file, { type: 'buffer' });
// const sheet = workbook.Sheets[workbook.SheetNames[0]];
// const data = XLSX.utils.sheet_to_json(sheet, { header: 1 });
// const result = {};

// for (const [province, region, city, policeStation] of data.slice(1)) {
//   if (!result[province]) result[province] = {};
//   if (!result[province][region]) result[province][region] = [];
//   result[province][region].push({ city, policeStation });

//   const stateData = await State.findOne({ where: { name: province } });
//   const cityData = await City.findOne({ where: { name: city } });
//   const regionData = await Region.findOne({ where: { name: region } });
// }
