import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";

const RequirementAnalysis = sequelize.define(
  "bcp_requirement_analysis",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    location: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    tasks: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assessment_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    lead_assessor: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assessment_participants: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    impact_analysis: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    overall_impact_score_24_hrs: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    overall_impact_score_7_days: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    overall_impact_score_7_days_plus: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    aggregate_activity_score: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    aggregate_information_required: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    occur_in_other_location: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    rto_value: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    rto_duration: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    mtpod_value: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    mtpod_duration: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    rpo_value: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    rpo_duration: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    rating_explanation: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    rating_undertaken: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "bcp_requirement_analysis",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
export default RequirementAnalysis;

// console.log(await RequirementAnalysis.sync({ alter: true }));
