import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";
import User from "./UserSchema.js";

const TESTING_FREQUENCY = Object.freeze([
  "Daily",
  "Weekly",
  "Bi-Weekly",
  "Monthly",
  "Bi-Monthly",
  "Quarterly",
  "Bi-Annually",
  "Annually",
]);
const BcpManagement = sequelize.define(
  "bcp_management",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    business_activity_details: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    plan_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    plan_reference_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    plan_version_number: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    plan_effective_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    plan_effective_end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    crisis_management_team_leader: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    crisis_management_team_leader_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    deputy_crisis_management_team_leader: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    deputy_crisis_management_team_leader_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    emergency_response_coordinator: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    emergency_response_coordinator_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    technical_recovery_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    technical_recovery_lead_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    communication_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    communication_officer_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    legal_and_compliance_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    legal_and_compliance_officer_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    hr_representative: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    hr_representative_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    operation_recovery_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    operation_recovery_lead_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    finance_and_administration_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    finance_and_administration_lead_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    facilities_and_physical_infrastructure: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    facilities_and_physical_infrastructure_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    supply_chain_and_procurement_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    supply_chain_and_procurement_lead_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    external_liaison_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    external_liaison_officer_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    security_lead: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    security_lead_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    risk_management_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    risk_management_officer_responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    crisis_documentation_officer: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    crisis_documentation_officer_responsibility: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    plan_external_emergency_numbers: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    purpose: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    objective: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    scope: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    assumptions: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    impact_analysis: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    recovery_strategies: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    communication_plan: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_response_procedures: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    plan_activation: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    lesson_learned_protocol: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    plan_testing_and_maintenance: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    testing_frequency: {
      type: DataTypes.ENUM(TESTING_FREQUENCY),
      allowNull: true,
      defaultValue: "Daily",
    },
    testing_cycles: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    testing_start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    next_review_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    upload_documents: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    reviewer: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    approver: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    bcp_requirement_analysis_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("reviewing", "approval", "approved", "rejected"),
      allowNull: true,
      defaultValue: "reviewing",
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    ...EndFields,
  },
  {
    tableName: "bcp_management",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await BcpManagement.sync({ alter: true }));

export default BcpManagement;
