import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import Sidebar from "./SidebarSchema.js";
import Currency from "./CurrencySchema.js";
import { EndFields } from "../constants/constants.js";
import AuditType from "./AuditTypeSchema.js";
import AuditTemplate from "./AuditTemplateSchema.js";
import Repository from "./RepositorySchema.js";

const scheduleTypeArr = Object.freeze([
  "audit",
  "inspection",
  "monitoring",
  "assessment",
  "surveillance",
  "certifications",
  "testing-examination",
]);
const linkedToArr = Object.freeze([
  "Permits",
  "SOPs",
  "Policy",
  "Action",
  "Incident",
  "NCR",
  "Business Continuity",
]);
const statusArr = Object.freeze([
  "To-do",
  "In progress",
  "Executed",
  "Overdue",
]);
const sourceArr = Object.freeze(["Internal", "External"]);
const participantArr = Object.freeze(["Internal", "External"]);
const evaluationStatusArr = Object.freeze([
  "Applicable",
  "Not Applicable",
  "Added",
  "Not Added",
]);

const AuditScheduling = sequelize.define(
  "AuditScheduling",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING(250),
    },
    type: {
      type: DataTypes.INTEGER,
      references: {
        model: AuditType,
        key: AuditType.primaryKeyAttribute,
      },
    },
    schedule_type: {
      type: DataTypes.ENUM(scheduleTypeArr),
    },
    linked_to: {
      type: DataTypes.ENUM(linkedToArr),
    },
    module: {
      type: DataTypes.INTEGER,
      references: {
        model: Sidebar,
        key: Sidebar.primaryKeyAttribute,
      },
    },
    sub_module: {
      type: DataTypes.INTEGER,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    planned_start_date: {
      type: DataTypes.DATEONLY,
    },
    planned_end_date: {
      type: DataTypes.DATEONLY,
    },
    actual_start_date: {
      type: DataTypes.DATEONLY,
    },
    actual_end_date: {
      type: DataTypes.DATEONLY,
    },
    want_to_repeat: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    source: {
      type: DataTypes.ENUM(sourceArr),
    },
    lead_person: {
      type: DataTypes.TEXT("long"),
    },
    reference_number: {
      type: DataTypes.INTEGER,
    },
    participant_type: {
      type: DataTypes.ENUM(participantArr),
    },
    stakeholder: {
      type: DataTypes.TEXT("long"),
    },
    record_name: {
      type: DataTypes.INTEGER,
    },
    location: {
      type: DataTypes.TEXT("long"),
    },
    repeat_when: {
      type: DataTypes.STRING(255),
    },
    cycles: {
      type: DataTypes.STRING(255),
    },
    members: {
      type: DataTypes.TEXT("long"),
    },
    owner: {
      type: DataTypes.INTEGER,
    },
    participants: {
      type: DataTypes.TEXT("long"),
    },
    scope: {
      type: DataTypes.TEXT("long"),
    },
    critical_business: {
      type: DataTypes.TEXT("long"),
    },
    financial_resource: {
      type: DataTypes.STRING(255),
    },
    operating_budget_value: {
      type: DataTypes.INTEGER,
    },
    operating_budget_currency: {
      type: DataTypes.INTEGER,
      references: {
        model: Currency,
        key: "id",
      },
    },
    capital_budget_value: {
      type: DataTypes.INTEGER,
    },
    capital_budget_currency: {
      type: DataTypes.INTEGER,
      references: {
        model: Currency,
        key: "id",
      },
    },
    opening_meeting_agenda: {
      type: DataTypes.TEXT("long"),
    },
    closing_meeting_agenda: {
      type: DataTypes.TEXT("long"),
    },
    evaluation_tool_status: {
      type: DataTypes.ENUM(evaluationStatusArr),
    },
    technological_resources: {
      type: DataTypes.TEXT("long"),
    },
    evaluation_tool: {
      type: DataTypes.INTEGER,
      references: {
        model: AuditTemplate,
        key: AuditTemplate.primaryKeyAttribute,
      },
    },
    audit_record: {
      type: DataTypes.INTEGER,
      references: {
        model: "audit_record",
        key: "id",
      },
    },
    status: {
      type: DataTypes.ENUM(statusArr),
      defaultValue: "To-do",
    },
    report: {
      type: DataTypes.STRING(1000),
    },
    unique_id: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      // onUpdate: "CASCADE",
      // onDelete: "SET NULL",
    },
    ...EndFields,
  },
  {
    tableName: "audit_scheduling",
    paranoid: true,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await AuditScheduling.sync({ alter: true }));
AuditScheduling.belongsTo(Repository, {
  foreignKey: "ddrm_id",
  as: "repository",
});

export default AuditScheduling;
