import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import AuditScheduling from "./AuditSchedulingSchema.js";

const AuditRecord = sequelize.define(
  "AuditRecord",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    description: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    audit_execution: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
    },
    audit_record: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    total_point: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    earned_points: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "audit_record",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// AuditRecord.belongsTo(AuditScheduling, {
//   as: "auditExecution",
//   foreignKey: "audit_execution",
// });
AuditRecord.belongsTo(Organization, {
  as: "org",
  foreignKey: "organization",
});
AuditRecord.belongsTo(Department, {
  as: "dep",
  foreignKey: "department",
});
AuditRecord.belongsTo(User, { as: "creator", foreignKey: "created_by" });
AuditRecord.belongsTo(User, { as: "updater", foreignKey: "updated_by" });
// console.log(await AuditRecord.sync({ alter: true }));
export default AuditRecord;
