import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateWasteType, deleteWasteType, viewWasteType } from "../controller/wasteTypeController.js";

/**
 * @swagger
 * tags:
 *   name: WasteType
 *   description: API operations for managing WasteType
 */
const wasteTypeRoutes = Router();

/**
 * @swagger
 * /api/wasteType/create-update-waste-type:
 *   post:
 *     summary: Create or update a WasteType
 *     tags: [WasteType]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
wasteTypeRoutes.post(
  "/create-update-waste-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 366 , "waste_type")(req, res, next);
  },
  controllerWrapper(createUpdateWasteType)
);

/**
 * @swagger
 * /api/wasteType/get-waste-type:
 *   get:
 *     summary: Get all records of WasteType
 *     tags: [WasteType]
 */
wasteTypeRoutes.get(
  "/get-waste-type",
  verifyToken,
  sideBarPermissionCheck("view", 366, "waste_type"),
  controllerWrapper(viewWasteType)
);

/**
 * @swagger
 * /api/wasteType/get-waste-type/{id}:
 *   get:
 *     summary: Get a specific record of WasteType
 *     tags: [WasteType]
 */
wasteTypeRoutes.get(
  "/get-waste-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 366, "waste_type"),
  controllerWrapper(viewWasteType)
);

/**
 * @swagger
 * /api/wasteType/delete-waste-type/{id}:
 *   delete:
 *     summary: Delete a specific record of WasteType
 *     tags: [WasteType]
 */
wasteTypeRoutes.delete(
  "/delete-waste-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 366, "waste_type"),
  controllerWrapper(deleteWasteType)
);

export default wasteTypeRoutes;