// Import necessary modules
import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import {
  accessRequest,
  updateSoftwareAccess,
} from "../controller/softwareAccessController.js";
import { controllerWrapper } from "../helper/wrapper.js";

/**
 * @swagger
 * tags:
 *   name: Software Access
 *   description: API operations for managing all alert type
 */
const softwareAccessRoutes = Router();

/**
 * @swagger
 * /api/softwareAccess/update-software-access:
 *   post:
 *     summary: Create or update an alert Type
 *     tags: [Software Access]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: {id: "id", type: "type", organizationId: "organization Id", permission: "permission", organizations: "organizations"}
 */
softwareAccessRoutes.post(
  "/update-software-access",
  verifyToken,
  controllerWrapper(updateSoftwareAccess)
);

/**
 * @swagger
 * /api/softwareAccess/request-access:
 *   post:
 *     summary: Create or update an alert Type
 *     tags: [Software Access]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example:
 *             id: "1"
 *             status: "Default Unapproved"
 *             reason: "Reason for the request"
 *             module_id: 1
 *             sub_module_id: 1
 *             access_type : ["view", "create", "edit", "delete"]
 */

softwareAccessRoutes.post(
  "/request-access",
  verifyToken,
  controllerWrapper(accessRequest)
);

export default softwareAccessRoutes;
