import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateRelation, deleteRelation, viewRelation } from "../controller/relationController.js";

/**
 * @swagger
 * tags:
 *   name:  relation
 *   description: API operations for managing  relation
 */
const relationRoutes = Router();

/**
 * @swagger
 * /api/relation/create-update-relation:
 *   post:
 *     summary: Create or update a  relation
 *     tags: [ relation]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
relationRoutes.post(
  "/create-update-relation",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 455 , "relation")(req, res, next);
  },
  controllerWrapper(createUpdateRelation)
);

/**
 * @swagger
 * /api/relation/get-relation:
 *   get:
 *     summary: Get all records of  relation
 *     tags: [ relation]
 */
relationRoutes.get(
  "/get-relation",
  verifyToken,
  sideBarPermissionCheck("view", 455, "relation"),
  controllerWrapper(viewRelation)
);

/**
 * @swagger
 * /api/relation/get-relation/{id}:
 *   get:
 *     summary: Get a specific record of  relation
 *     tags: [ relation]
 */
relationRoutes.get(
  "/get-relation/:id",
  verifyToken,
  sideBarPermissionCheck("view", 455, "relation"),
  controllerWrapper(viewRelation)
);

/**
 * @swagger
 * /api/relation/delete-relation/{id}:
 *   delete:
 *     summary: Delete a specific record of  relation
 *     tags: [ relation]
 */
relationRoutes.delete(
  "/delete-relation/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 455, "relation"),
  controllerWrapper(deleteRelation)
);

export default relationRoutes;