import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateRegulator, deleteRegulator, viewRegulator } from "../controller/regulatorController.js";

/**
 * @swagger
 * tags:
 *   name:  regulator
 *   description: API operations for managing  regulator
 */
const regulatorRoutes = Router();

/**
 * @swagger
 * /api/regulator/create-update-regulator:
 *   post:
 *     summary: Create or update a  regulator
 *     tags: [ regulator]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
regulatorRoutes.post(
  "/create-update-regulator",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 405 , "regulator")(req, res, next);
  },
  controllerWrapper(createUpdateRegulator)
);

/**
 * @swagger
 * /api/regulator/get-regulator:
 *   get:
 *     summary: Get all records of  regulator
 *     tags: [ regulator]
 */
regulatorRoutes.get(
  "/get-regulator",
  verifyToken,
  sideBarPermissionCheck("view", 405, "regulator"),
  controllerWrapper(viewRegulator)
);

/**
 * @swagger
 * /api/regulator/get-regulator/{id}:
 *   get:
 *     summary: Get a specific record of  regulator
 *     tags: [ regulator]
 */
regulatorRoutes.get(
  "/get-regulator/:id",
  verifyToken,
  sideBarPermissionCheck("view", 405, "regulator"),
  controllerWrapper(viewRegulator)
);

/**
 * @swagger
 * /api/regulator/delete-regulator/{id}:
 *   delete:
 *     summary: Delete a specific record of  regulator
 *     tags: [ regulator]
 */
regulatorRoutes.delete(
  "/delete-regulator/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 405, "regulator"),
  controllerWrapper(deleteRegulator)
);

export default regulatorRoutes;