import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateProcesses, deleteProcesses, viewProcesses } from "../controller/processesController.js";

/**
 * @swagger
 * tags:
 *   name:  processes
 *   description: API operations for managing  processes
 */
const processesRoutes = Router();

/**
 * @swagger
 * /api/processes/create-update-processes:
 *   post:
 *     summary: Create or update a  processes
 *     tags: [ processes]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
processesRoutes.post(
  "/create-update-processes",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 405 , "processes")(req, res, next);
  },
  controllerWrapper(createUpdateProcesses)
);

/**
 * @swagger
 * /api/processes/get-processes:
 *   get:
 *     summary: Get all records of  processes
 *     tags: [ processes]
 */
processesRoutes.get(
  "/get-processes",
  verifyToken,
  sideBarPermissionCheck("view", 405, "processes"),
  controllerWrapper(viewProcesses)
);

/**
 * @swagger
 * /api/processes/get-processes/{id}:
 *   get:
 *     summary: Get a specific record of  processes
 *     tags: [ processes]
 */
processesRoutes.get(
  "/get-processes/:id",
  verifyToken,
  sideBarPermissionCheck("view", 405, "processes"),
  controllerWrapper(viewProcesses)
);

/**
 * @swagger
 * /api/processes/delete-processes/{id}:
 *   delete:
 *     summary: Delete a specific record of  processes
 *     tags: [ processes]
 */
processesRoutes.delete(
  "/delete-processes/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 405, "processes"),
  controllerWrapper(deleteProcesses)
);

export default processesRoutes;