import {
  seenOrReadNotification,
  viewAllNotification,
} from "../controller/notificationController.js";
import { verifyToken } from "../helper/tokenVerify.js";
import { Router } from "express";
import { controllerWrapper } from "../helper/wrapper.js";

/**
 * @swagger
 * tags:
 *   name: Notification
 *   description: API operations for managing all NotificationTypes
 */

const notificationRoutes = Router();

/**
 * @swagger
 * /api/notification/get-notification:
 *   get:
 *     summary: Get all list of notifications
 *     tags: [Notification]
 */
notificationRoutes.get(
  "/get-notification",
  verifyToken,
  controllerWrapper(viewAllNotification)
);

/**
 * @swagger
 * /api/notification/update-seen-read-notification:
 *   post:
 *     summary: Send or read notifications
 *     tags: [Notification]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: {
 *             "id": "123",
 *             "type": "notification type",
 *             "action": "seen"
 *           }
 *     responses:
 *       200:
 *         description: Successfully updated notification status
 *       400:
 *         description: Bad request
 *       401:
 *         description: Unauthorized
 *       500:
 *         description: Internal server error
 */
notificationRoutes.post(
  "/update-seen-read-notification",
  verifyToken,
  controllerWrapper(seenOrReadNotification)
);

export default notificationRoutes;
