import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateLanguage, deleteLanguage, viewLanguage } from "../controller/languageController.js";
/**
 * @swagger
 * tags:
 *   name:  language
 *   description: API operations for managing  language
 */
const languageRoutes = Router();

/**
 * @swagger
 * /api/language/create-update-language:
 *   post:
 *     summary: Create or update a  language
 *     tags: [ language]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
languageRoutes.post(
  "/create-update-language",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 369 , "language")(req, res, next);
  },
  controllerWrapper(createUpdateLanguage)
);

/**
 * @swagger
 * /api/language/get-language:
 *   get:
 *     summary: Get all records of  language
 *     tags: [ language]
 */
languageRoutes.get(
  "/get-language",
  verifyToken,
  sideBarPermissionCheck("view", 369, "language"),
  controllerWrapper(viewLanguage)
);

/**
 * @swagger
 * /api/language/get-language/{id}:
 *   get:
 *     summary: Get a specific record of  language
 *     tags: [ language]
 */
languageRoutes.get(
  "/get-language/:id",
  verifyToken,
  sideBarPermissionCheck("view", 369, "language"),
  controllerWrapper(viewLanguage)
);

/**
 * @swagger
 * /api/language/delete-language/{id}:
 *   delete:
 *     summary: Delete a specific record of  language
 *     tags: [ language]
 */
languageRoutes.delete(
  "/delete-language/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 369, "language"),
  controllerWrapper(deleteLanguage)
);

export default languageRoutes;