import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateEngagementLevels, deleteEngagementLevels, viewEngagementLevels } from "../controller/engagementLevelsController.js";

/**
 * @swagger
 * tags:
 *   name:  engagement levels
 *   description: API operations for managing  engagement levels
 */
const engagementLevelsRoutes = Router();

/**
 * @swagger
 * /api/engagementLevels/create-update-engagement-levels:
 *   post:
 *     summary: Create or update a  engagement levels
 *     tags: [ engagement levels]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
engagementLevelsRoutes.post(
  "/create-update-engagement-levels",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 408 , "engagement_levels")(req, res, next);
  },
  controllerWrapper(createUpdateEngagementLevels)
);

/**
 * @swagger
 * /api/engagementLevels/get-engagement-levels:
 *   get:
 *     summary: Get all records of  engagement levels
 *     tags: [ engagement levels]
 */
engagementLevelsRoutes.get(
  "/get-engagement-levels",
  verifyToken,
  sideBarPermissionCheck("view", 408, "engagement_levels"),
  controllerWrapper(viewEngagementLevels)
);

/**
 * @swagger
 * /api/engagementLevels/get-engagement-levels/{id}:
 *   get:
 *     summary: Get a specific record of  engagement levels
 *     tags: [ engagement levels]
 */
engagementLevelsRoutes.get(
  "/get-engagement-levels/:id",
  verifyToken,
  sideBarPermissionCheck("view", 408, "engagement_levels"),
  controllerWrapper(viewEngagementLevels)
);

/**
 * @swagger
 * /api/engagementLevels/delete-engagement-levels/{id}:
 *   delete:
 *     summary: Delete a specific record of  engagement levels
 *     tags: [ engagement levels]
 */
engagementLevelsRoutes.delete(
  "/delete-engagement-levels/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 408, "engagement_levels"),
  controllerWrapper(deleteEngagementLevels)
);

export default engagementLevelsRoutes;