import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { createUpdateDDRM, deleteDDRM, getDDRM } from "../controller/ddrmController.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";

const DDRMRoutes = Router();

DDRMRoutes.post(
    "/create-update-assigned-document",
    verifyToken,
    (req, res, next) => {
      sideBarPermissionCheck(
        req.body.id ? "edit" : "create",
        428,
        "ddrm"
      )(req, res, next);
    },
    controllerWrapper(createUpdateDDRM)
  );


  DDRMRoutes.get(
    "/get-assigned-document",
    verifyToken,
    controllerWrapper(getDDRM)
  );

  DDRMRoutes.get(
    "/get-assigned-document/:id",
    verifyToken,
    sideBarPermissionCheck("view", 428, "ddrm"),
    controllerWrapper(getDDRM)
  );

  DDRMRoutes.delete(
    "/delete-assigned-document/:id",
    verifyToken,
    sideBarPermissionCheck("delete", 428, "ddrm"),
    controllerWrapper(deleteDDRM)
  );

export default DDRMRoutes;