import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCriticalSystemAffected, deleteCriticalSystemAffected, viewCriticalSystemAffected } from "../controller/criticalSystemAffectedController.js";

/**
 * @swagger
 * tags:
 *   name:  critical system affected
 *   description: API operations for managing  critical system affected
 */
const criticalSystemAffectedRoutes = Router();

/**
 * @swagger
 * /api/criticalSystemAffected/create-update-critical-system-affected:
 *   post:
 *     summary: Create or update a  critical system affected
 *     tags: [ critical system affected]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
criticalSystemAffectedRoutes.post(
  "/create-update-critical-system-affected",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 451 , "critical_system_affected")(req, res, next);
  },
  controllerWrapper(createUpdateCriticalSystemAffected)
);

/**
 * @swagger
 * /api/criticalSystemAffected/get-critical-system-affected:
 *   get:
 *     summary: Get all records of  critical system affected
 *     tags: [ critical system affected]
 */
criticalSystemAffectedRoutes.get(
  "/get-critical-system-affected",
  verifyToken,
  sideBarPermissionCheck("view", 451, "critical_system_affected"),
  controllerWrapper(viewCriticalSystemAffected)
);

/**
 * @swagger
 * /api/criticalSystemAffected/get-critical-system-affected/{id}:
 *   get:
 *     summary: Get a specific record of  critical system affected
 *     tags: [ critical system affected]
 */
criticalSystemAffectedRoutes.get(
  "/get-critical-system-affected/:id",
  verifyToken,
  sideBarPermissionCheck("view", 451, "critical_system_affected"),
  controllerWrapper(viewCriticalSystemAffected)
);

/**
 * @swagger
 * /api/criticalSystemAffected/delete-critical-system-affected/{id}:
 *   delete:
 *     summary: Delete a specific record of  critical system affected
 *     tags: [ critical system affected]
 */
criticalSystemAffectedRoutes.delete(
  "/delete-critical-system-affected/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 451, "critical_system_affected"),
  controllerWrapper(deleteCriticalSystemAffected)
);

export default criticalSystemAffectedRoutes;