import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCommandCenterLocation, deleteCommandCenterLocation, viewCommandCenterLocation } from "../controller/commandCenterLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  command center location
 *   description: API operations for managing  command center location
 */
const commandCenterLocationRoutes = Router();

/**
 * @swagger
 * /api/commandCenterLocation/create-update-command-center-location:
 *   post:
 *     summary: Create or update a  command center location
 *     tags: [ command center location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
commandCenterLocationRoutes.post(
  "/create-update-command-center-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 448 , "command_center_location")(req, res, next);
  },
  controllerWrapper(createUpdateCommandCenterLocation)
);

/**
 * @swagger
 * /api/commandCenterLocation/get-command-center-location:
 *   get:
 *     summary: Get all records of  command center location
 *     tags: [ command center location]
 */
commandCenterLocationRoutes.get(
  "/get-command-center-location",
  verifyToken,
  sideBarPermissionCheck("view", 448, "command_center_location"),
  controllerWrapper(viewCommandCenterLocation)
);

/**
 * @swagger
 * /api/commandCenterLocation/get-command-center-location/{id}:
 *   get:
 *     summary: Get a specific record of  command center location
 *     tags: [ command center location]
 */
commandCenterLocationRoutes.get(
  "/get-command-center-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 448, "command_center_location"),
  controllerWrapper(viewCommandCenterLocation)
);

/**
 * @swagger
 * /api/commandCenterLocation/delete-command-center-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  command center location
 *     tags: [ command center location]
 */
commandCenterLocationRoutes.delete(
  "/delete-command-center-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 448, "command_center_location"),
  controllerWrapper(deleteCommandCenterLocation)
);

export default commandCenterLocationRoutes;