import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateBusinessProcesses,
  deleteBusinessProcesses,
  viewBusinessProcesses,
} from "../controller/businessProcessesController.js";

/**
 * @swagger
 * tags:
 *   name:  business processes
 *   description: API operations for managing  business processes
 */
const businessProcessesRoutes = Router();

/**
 * @swagger
 * /api/businessProcesses/create-update-business-processes:
 *   post:
 *     summary: Create or update a  business processes
 *     tags: [ business processes]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
businessProcessesRoutes.post(
  "/create-update-business-processes",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 457, "business_processes")(req, res, next);
  },
  controllerWrapper(createUpdateBusinessProcesses)
);

/**
 * @swagger
 * /api/businessProcesses/get-business-processes:
 *   get:
 *     summary: Get all records of  business processes
 *     tags: [ business processes]
 */
businessProcessesRoutes.get(
  "/get-business-processes",
  verifyToken,
  sideBarPermissionCheck("view", 457, "business_processes"),
  controllerWrapper(viewBusinessProcesses)
);

/**
 * @swagger
 * /api/businessProcesses/get-business-processes/{id}:
 *   get:
 *     summary: Get a specific record of  business processes
 *     tags: [ business processes]
 */
businessProcessesRoutes.get(
  "/get-business-processes/:id",
  verifyToken,
  sideBarPermissionCheck("view", 457, "business_processes"),
  controllerWrapper(viewBusinessProcesses)
);

/**
 * @swagger
 * /api/businessProcesses/delete-business-processes/{id}:
 *   delete:
 *     summary: Delete a specific record of  business processes
 *     tags: [ business processes]
 */
businessProcessesRoutes.delete(
  "/delete-business-processes/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 457, "business_processes"),
  controllerWrapper(deleteBusinessProcesses)
);

export default businessProcessesRoutes;
