// import nodemailer from "nodemailer";
import fs from "fs";
import path from "path";
import { fileURLToPath } from "url";
import axios from "axios";
import FormData from "form-data";
import moment from "moment";
const superAdminApiUrl = process.env.SUPER_ADMIN_BACKEND_URL;
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

/**Send Data According to mail*/
export const returnData = async (sendRecordArray) => {
  if (sendRecordArray.templateFileUrl == "forgot_password_template.html") {
    const data = {
      name: sendRecordArray.name,
      otp: sendRecordArray.otp,
    };
    return data;
  } else {
    return sendRecordArray;
  }
};

// now used for sending payload to super-admin for sending email on super admin side
/**
 *
 * @param {string} fromMail
 * @param {string} toMail
 * @param {string} subjectData
 * @param {Array} sendRecordArray
 * @param {object} file
 * @returns
 */
export async function sendEmail(
  fromMail,
  toMail,
  subjectData,
  sendRecordArray,
  file
) {
  try {

    const formattedPayload = {
      fromMail: fromMail,
      toMail: toMail,
      alertSentDateTime: moment().format("YYYY-MM-DD HH:mm:ss"),
      subjectData: subjectData,
      sendRecordArray: sendRecordArray,
    };

    // Create a FormData object
    const formData = new FormData();

    // Append fields to FormData
    Object.keys(formattedPayload).forEach((key) => {
      let value = formattedPayload[key];

      // If the value is an object (like sendRecordArray), stringify it
      if (typeof value === "object" && value !== null) {
        const serializableValue = { ...value };
        delete serializableValue.emit; // Remove the function
        value = JSON.stringify(serializableValue); // Convert to string
      }
      formData.append(key, value);
    });

    // Read the file from the filesystem and append it
    if (file) {
      const filePath = file.uri; // Use the URI as the file path
      const fileContent = fs.readFileSync(filePath); // Read file as Buffer
      formData.append("file", fileContent, {
        filename: file.name, // Specify the file name
        contentType: file.type, // Specify the MIME type
      });
    }

    const fullUrl = `${superAdminApiUrl}/api/send-email`;

    const response = await axios.post(fullUrl, formData, {
      headers: {
        ...formData.getHeaders(), // Use form-data headers (includes boundary)
      },
    });
    console.log(
      `Client service: ${subjectData} data successfully sent to super admin service.`,
      { data: response.data }
    );
    return { success: true };
  } catch (error) {
    console.error("Error sending payload:", error);
    // throw error;
    return;
  }
}

export default sendEmail;
