import Excel from "exceljs";
import path from "path";
import fs from "fs";
import db from "../db-config.js";
import asyncHandler from "express-async-handler";
import { whereCondition } from "./general.js";

// Create a new workbook

export const getObjectivesAndTargetRegisterExcel = asyncHandler(
  async (req, res) => {
    try {
      const workbook = new Excel.Workbook();
      // Add a worksheet
      const worksheet = workbook.addWorksheet(
        "Objectives and Targets Register"
      );

      // Define the column headers
      const headers = [
        { header: "No.", key: "no", width: 5 },
        { header: "Objective Title", key: "objectiveTitle", width: 30 },
        { header: "Target Title", key: "targetTitle", width: 20 },
        { header: "KPI Title", key: "kpiTitle", width: 20 },
        { header: "Date Generated", key: "dateGenerated", width: 30 },
        { header: "Objective Owner", key: "objectiveOwner", width: 30 },
        { header: "Business Structure", key: "businessStructure", width: 30 },
      ];

      // Merge cells for the main heading

      const condition = await whereCondition({
        table: "objective_setting",
        page: req.query.page,
        all: req.query.all,
        pageSize: req.query.pageSize,
        filter: req.query.filter,
        id: "",
        grouped: req.query.grouped,
        user: req.user,
      });

      // Sample data
      const query = `SELECT objective_setting.id as no ,objective_setting.objective_name as objectiveTitle , objective_setting.target_name as targetTitle , objective_setting.kpi_name as kpiTitle , objective_setting.date_generated as dateGenerated , CONCAT(users.name, ' ', users.surname) as objectiveOwner , organization.name as businessStructure FROM objective_setting LEFT JOIN users ON objective_owner = users.id LEFT JOIN organization on objective_setting.organization = organization.id
    Where objective_setting.deleted = 0 ${condition}`;
      const [dataFetch] = await db.query(query);

      worksheet.mergeCells(`A1:${String.fromCharCode(64 + headers.length)}1`);
      worksheet.getCell("A1").value = "Objectives and Targets Register";
      worksheet.getCell("A1").alignment = { horizontal: "center" }; // Center align the text

      // Add the headers to the worksheet
      worksheet.addRow(headers.map((header) => header.header));
      // console.log(dataFetch);
      // Add data to the worksheet
      // Add data to the worksheet
      dataFetch.forEach((row) => {
        worksheet.addRow(Object.values(row));
      });

      const heading = worksheet.getRow(1);
      heading.height = 30;
      heading.eachCell((cell) => {
        cell.fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: "0000FF" }, // Red color
        };
        cell.font = {
          color: { argb: "FFFFFF" },
          size: 20, // White color for text
        };
      });

      const colHeading = worksheet.getRow(2);
      colHeading.height = 20;
      colHeading.eachCell((cell) => {
        cell.fill = {
          type: "pattern",
          pattern: "solid",
          fgColor: { argb: "FF0000" }, // Blue color
        };
        cell.font = {
          color: { argb: "FFFFFF" }, // White color for text
          size: 16,
        };
        // Set alignment to center
        cell.alignment = { vertical: "middle", horizontal: "center" };
      });
      // Adjust column widths
      worksheet.columns.forEach((column, index) => {
        const header = headers[index];
        if (header && header.width) {
          column.width = header.width;
        }
        // Add the headers to the worksheet and set the background color to red
      });

      // Iterate over each row in the worksheet
      worksheet.eachRow({ includeEmpty: false }, function (row, rowNumber) {
        // Iterate over each cell in the row
        row.eachCell({ includeEmpty: false }, function (cell, colNumber) {
          // Set the border for each cell
          cell.border = {
            top: { style: "medium" }, // Thin top border
            left: { style: "medium" }, // Thin left border
            bottom: { style: "medium" }, // Thin bottom border
            right: { style: "medium" }, // Thin right border
            // You can adjust the style to 'medium' or 'thick' for darker or bolder borders
          };
          // Set alignment to center
          cell.alignment = { vertical: "middle", horizontal: "center" };
        });
      });

      // Get the current working directory
      const cwd = process.cwd();

      const publicFolderPath = path.join(cwd, "public");
      const excelFolderPath = path.join(publicFolderPath, "excel");
      if (!fs.existsSync(excelFolderPath)) {
        fs.mkdirSync(excelFolderPath, { recursive: true });
      }
      const filePath = path.join(excelFolderPath, "Objectives_and_Targets_Register.xlsx");

      // Save the workbook
      await workbook.xlsx.writeFile(filePath);
      return res.status(200).json({
        status: true,
        message: "Excel file created successfully",
        data: `excel/Objectives_and_Targets_Register.xlsx`,
      });
    } catch (error) {
      return res.status(500).json({
        status: false,
        message: error.message,
      });
    }
  }
);
