import db from "../db-config.js";
import {
  countQueryCondition,
  deleteRecord,
  insertActivityLog,
  searchConditionRecord,
  whereCondition,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import SHELegalRegister from "../sequelize/SHELegalRegisterSchema.js";
/**Function to create and update Alert   */
export const storeSheLegalWithApi = async (req, res) => {
  const url = "https://legalregister.harmonyuniverse.co.za/api/legalregister/";
  const token = "Bearer Y29kZXg6cmVzd_HARMONY_UNIVERSE_IMS";
  const response = await fetch(url, {
    headers: {
      Authorization: token,
    },
  });
  if (!response.ok) {
    throw new Error("Failed to fetch data");
  }
  const organizations = [1];

  const data = await response.json();
  const transformedData = await transformKeys(data);

  for (const organization of organizations) {
    for (const transformedDataRecord of transformedData) {
      const insertSheRiskRegisterQuery = `INSERT INTO she_legal_register (risk_given_id,function_record,title,regulatory_body,legislation_sector_type,hierarchy_of_legislation,subordinate,heading,level_of_legislation,description_of_level,provision_of_the_requirement,interpretation_of_the_provision,comment_action_implication, organization,consequences_of_non_compliance) VALUES (?,?, ?, ?, ? ,?, ?, ?, ? ,?, ?, ?, ? ,? ,?)`;
      await db.query(insertSheRiskRegisterQuery, [
        transformedDataRecord.risk_given_id,
        transformedDataRecord.function_record,
        transformedDataRecord.title,
        transformedDataRecord.regulatory_body,
        transformedDataRecord.legislation_sector_type,
        transformedDataRecord.hierarchy_of_legislation,
        transformedDataRecord.subordinate,
        transformedDataRecord.heading,
        transformedDataRecord.level_of_legislation,
        transformedDataRecord.description_of_level,
        transformedDataRecord.provision_of_the_requirement,
        transformedDataRecord.interpretation_of_the_provision,
        transformedDataRecord.comment_action_implication,
        organization,
        transformedDataRecord.consequences_of_non_compliance,
      ]);
    }
  }
  return sendResponse(res, 200, "Record stored successfully");
};

export async function transformKeys(data) {
  const keyMapping = {
    ID: "risk_given_id",
    Function: "function_record",
    Title: "title",
    "Regulatory Body": "regulatory_body",
    "Legislation Sector Type": "legislation_sector_type",
    "Hierarchy of Legislation": "hierarchy_of_legislation",
    Subordinate: "subordinate",
    Heading: "heading",
    "Level of Legislation": "level_of_legislation",
    "Description of Level": "description_of_level",
    "Provision of the Requirement": "provision_of_the_requirement",
    "Interpretation of the Provision": "interpretation_of_the_provision",
    "Comment/Action/Implication": "comment_action_implication",
    "Consequences of non-compliance": "consequences_of_non_compliance",
  };

  const transformedData = Array.isArray(data) ? [] : {}; // Handle array of objects

  for (const key in data) {
    if (data.hasOwnProperty(key)) {
      const value = data[key];
      if (typeof value === "object") {
        // Recursively transform nested objects
        transformedData[key] = await transformKeys(value);
      } else if (keyMapping.hasOwnProperty(key)) {
        transformedData[keyMapping[key]] = value;
      }
    }
  }
  return transformedData;
}

/**Function to view all  she legal register */
export const viewSheLegalRegister = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "she_legal_register",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    // user: req.user,
  });
  const searchTableName = [
    "she_legal_register.hierarchy_of_legislation",
    "she_legal_register.level_of_legislation",
    "she_legal_register.heading",
    "she_legal_register.legislation_sector_type",
    "she_legal_register.description_of_level",
    "she_legal_register.provision_of_the_requirement",
    "she_legal_register.interpretation_of_the_provision",
    "she_legal_register.comment_action_implication",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Record of all she_legal_register */
  const sheLegalRegisterQuery = `SELECT she_legal_register.*
    FROM she_legal_register where she_legal_register.deleted = 0  ${searchCondition} ${condition}`;

  const [sheLegalRegister] = await db.query(sheLegalRegisterQuery);

  const totalRecord = await countQueryCondition(sheLegalRegisterQuery);

  return sendResponse(res, 200, sheLegalRegister, totalRecord);
};

/**Function to delete a specific she legal register */
export const deleteSheLegalRegister = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteRecord("she_legal_register", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "She Legal Register",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};

/**Function to delete a specific she legal register */
export const updateSheLegalRegister = async (req, res) => {
  const {
    id,
    risk_given_id,
    function_record,
    title,
    regulatory_body,
    legislation_sector_type,
    hierarchy_of_legislation,
    subordinate,
    heading,
    level_of_legislation,
    description_of_level,
    provision_of_the_requirement,
    interpretation_of_the_provision,
    comment_action_implication,
    consequences_of_non_compliance,
    organization,
  } = req.params;

  const updateObjectiveSettingQuery = `UPDATE objective_setting SET risk_given_id = ?, function_record = ?, title = ?, regulatory_body = ?, legislation_sector_type = ?, hierarchy_of_legislation = ?, subordinate = ?, heading = ?, level_of_legislation = ?, description_of_level = ?, provision_of_the_requirement = ?, interpretation_of_the_provision = ?, comment_action_implication = ?, consequences_of_non_compliance = ?, organization = ? WHERE id = ?;`;
  const updateObjectiveSettingValues = [
    risk_given_id,
    function_record,
    title,
    regulatory_body,
    legislation_sector_type,
    hierarchy_of_legislation,
    subordinate,
    heading,
    level_of_legislation,
    description_of_level,
    provision_of_the_requirement,
    interpretation_of_the_provision,
    comment_action_implication,
    consequences_of_non_compliance,
    organization,
    id,
  ];
  const [updateObjectiveSetting] = await db.query(
    updateObjectiveSettingQuery,
    updateObjectiveSettingValues
  );

  /**Insert record for activity log */
  await insertActivityLog(
    req.user.sessionid,
    "update",
    "She Legal Register",
    id
  );
  return sendResponse(res, 200, "Record updated successfully");
};
// export const sheLegalSearchBarFilter = async (req, res) => {
//   let array = [
//     "function_record",
//     "title",
//     "regulatory_body",
//     "legislation_sector_type",
//     "hierarchy_of_legislation",
//     "subordinate",
//   ];

//   let obj = {
//     function_record: "title",
//     title: "regulatory_body",
//     regulatory_body: "legislation_sector_type",
//     legislation_sector_type: "hierarchy_of_legislation",
//     hierarchy_of_legislation: "subordinate",
//   };

//   // Extracting selectedFields, distinct, and where from the request query
//   let { where } = req.query;
//   where = JSON.parse(where ? where : "{}");
//   let skipFilter = "";
//   for (let key of array) {
//     if (where[key]) {
//       skipFilter = key;
//     }
//   }
//   console.log(where, "where");
//   console.log("skipFilter: ", skipFilter);
//   const dataObj = {};
//   let whereCondition = "";
//   const promises = array.map(async (distinctColumn, index) => {
//     console.log("where[distinctColumn]", where[distinctColumn]);
//     if (
//       where[distinctColumn] &&
//       where[distinctColumn] != "" &&
//       skipFilter != distinctColumn
//     ) {
//       console.log("hello");
//       whereCondition += ` AND ${distinctColumn} = '${where[distinctColumn]}'`;
//     } else {
//       // console.log(index, 1, distinctColumn, skipFilter);
//     }
//     console.log("whereCondition: ", whereCondition);
//     const Query = `SELECT DISTINCT ${distinctColumn} as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${
//       index == 0 ? "" : whereCondition
//     }`;
//     // console.log("Query: ", Query);
//     const [data] = await db.query(Query);
//     console.log(skipFilter, distinctColumn, "skipFilter: ");
//     if (skipFilter === distinctColumn) {
//       console.log("jjjj");
//       whereCondition += ` AND ${distinctColumn} = '${where[distinctColumn]}'`;
//     }
//     dataObj[distinctColumn] = data;
//   });
//   await Promise.all(promises);
//   return sendResponse(res, 200, dataObj);
// };

export const sheLegalSearchBarFilter = async (req, res) => {
  let array = [
    "function_record",
    "title",
    "regulatory_body",
    "legislation_sector_type",
    "hierarchy_of_legislation",
    "subordinate",
  ];

  let obj = {
    function_record: "title",
    title: "regulatory_body",
    regulatory_body: "legislation_sector_type",
    legislation_sector_type: "hierarchy_of_legislation",
    hierarchy_of_legislation: "subordinate",
  };

  // Extracting selectedFields, distinct, and where from the request query
  let { where } = req.query;
  where = JSON.parse(where ? where : "{}");
  let dataObj = {};
  const function_record_filter = where.function_record
    ? `AND function_record = '${where.function_record}'`
    : "";
  const title_filter = where.title ? `AND title = '${where.title}'` : "";
  const regulatory_body_filter = where.regulatory_body
    ? `AND regulatory_body = '${where.regulatory_body}'`
    : "";
  const legislation_sector_type_filter = where.legislation_sector_type
    ? `AND legislation_sector_type = '${where.legislation_sector_type}'`
    : "";
  const hierarchy_of_legislation_filter = where.hierarchy_of_legislation
    ? `AND hierarchy_of_legislation = '${where.hierarchy_of_legislation}'`
    : "";
  const subordinate_filter = where.subordinate
    ? `AND subordinate = '${where.subordinate}'`
    : "";
  let functionRecordQuery = `SELECT DISTINCT function_record as title FROM she_legal_register WHERE she_legal_register.deleted = 0`;
  const [data] = await db.query(functionRecordQuery);
  dataObj.function_record = data;

  let titleQuery = `SELECT DISTINCT title as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${function_record_filter}`;
  const [titleData] = await db.query(titleQuery);
  dataObj.title = titleData;

  let regulatoryBodyQuery = `SELECT DISTINCT regulatory_body as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${function_record_filter} ${title_filter}`;
  const [regulatoryBodyData] = await db.query(regulatoryBodyQuery);
  dataObj.regulatory_body = regulatoryBodyData;

  let legislationSectorTypeQuery = `SELECT DISTINCT legislation_sector_type as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${function_record_filter} ${title_filter} ${regulatory_body_filter}`;
  const [legislationSectorTypeData] = await db.query(
    legislationSectorTypeQuery
  );
  dataObj.legislation_sector_type = legislationSectorTypeData;

  let hierarchyOfLegislationQuery = `SELECT DISTINCT hierarchy_of_legislation as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${function_record_filter} ${title_filter} ${regulatory_body_filter} ${legislation_sector_type_filter}`;
  const [hierarchyOfLegislationData] = await db.query(
    hierarchyOfLegislationQuery
  );
  dataObj.hierarchy_of_legislation = hierarchyOfLegislationData;

  let subordinateQuery = `SELECT DISTINCT subordinate as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${function_record_filter} ${title_filter} ${regulatory_body_filter} ${legislation_sector_type_filter} ${hierarchy_of_legislation_filter}`;
  const [subordinateData] = await db.query(subordinateQuery);
  dataObj.subordinate = subordinateData;
  return sendResponse(res, 200, dataObj);
};

// export const sheLegalSearchBarFilter = async (req, res) => {
//   let array = [
//     "function_record",
//     "title",
//     "regulatory_body",
//     "legislation_sector_type",
//     "hierarchy_of_legislation",
//     "subordinate",
//   ];

//   let obj = {
//     function_record: "title",
//     title: "regulatory_body",
//     regulatory_body: "legislation_sector_type",
//     legislation_sector_type: "hierarchy_of_legislation",
//     hierarchy_of_legislation: "subordinate",
//   };

//   // Extracting selectedFields, distinct, and where from the request query
//   let { where } = req.query;
//   where = JSON.parse(where ? where : "{}");

//   const keys = Object.keys(where);
//   let current = -Infinity;
//   for (let i = 0; i < keys.length; i++) {
//     let key = keys[i];
//     console.log(key, "key");
//     const index = array.indexOf(key);
//     if (index !== -1 && index > current) {
//       current = index;
//     } else if (index == -1) {
//       return sendResponse(res, 400, "Unknown filter provided");
//     }
//   }

//   // Parse the `where` parameter if provided

//   // Construct the `whereCondition` string
//   let whereCondition = "";
//   for (let key in where) {
//     if (where[key] != "") {
//       whereCondition += ` AND ${key} = '${where[key]}'`;
//     }
//   }
//   const dataObj = {};
//   const promises = array.map(async (distinctColumn, index) => {
//     console.log(current, "current");
//     if (index > current) {
//       const Query = `SELECT DISTINCT ${distinctColumn} as title FROM she_legal_register WHERE she_legal_register.deleted = 0 ${whereCondition} `;
//       const [data] = await db.query(Query);
//       dataObj[distinctColumn] = data;
//     } else {
//       const Query = `SELECT DISTINCT ${distinctColumn} as title FROM she_legal_register WHERE she_legal_register.deleted = 0`;
//       const [data] = await db.query(Query);
//       dataObj[distinctColumn] = data;
//     }
//   });
//   await Promise.all(promises);
//   return sendResponse(res, 200, dataObj);
// };
