import PoliceStation from "../sequelize/PoliceStationSchema.js";
import db from "../db-config.js";

export async function getPoliceStation(req, res) {
  let { id, city_id } = req.params;

  if (city_id) {
    const [policeStation] = await db.query(
      `SELECT police_station.id, police_station.name,cities.name as cityName FROM police_station LEFT JOIN cities ON cities.id = police_station.city_id WHERE  police_station.deleted = 0 AND cities.id = ?`,
      [city_id]
    );

    return res.status(200).json({ status: true, data: policeStation });
  }

  id = parseInt?.(id);
  if (id && !parseInt(id)) {
    return res.status(400).json({
      status: false,
      message: "Invalid police station id",
    });
  }
  if (!parseInt?.(id)) {
    const [policeStations] = await db.query(
      `SELECT police_station.id , police_station.name,cities.name as cityName FROM police_station LEFT JOIN cities ON cities.id = police_station.city_id WHERE  police_station.deleted = 0`
    );
    return res.status(200).json({ status: true, data: policeStations });
  }

  const [policeStations] = await db.query(
    `SELECT police_station.id, police_station.name,cities.name as cityName FROM police_station LEFT JOIN cities ON cities.id = police_station.city_id WHERE  police_station.deleted = 0 AND police_station.id = ?`,
    [id]
  );

  return res.status(200).json({ status: true, data: policeStations });
}
