import db from "../db-config.js";
import {
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  whereCondition,
  searchConditionRecord,
  settingsUpdater,
  countQueryCondition,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getRecord,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import ParentObjective from "../sequelize/ParentObjectiveSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { updateQueryBuilder } from "../helper/queryBuilder.js";

/** Function to create and update Parent Objective */
export const createUpdateParentObjective = async (req, res) => {
  const { name, description, id, organization } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "ParentObjective",
      "parent_objective",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "parent_objective",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Parent Objective name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Parent Objective name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(ParentObjective, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "ParentObjective",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(ParentObjective, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "ParentObjective",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // req.body.description = encodedDescription;

  // /** If id comes in body then it will update the query */
  // if (id) {
  //   req.body.updated_by = req.user.sessionid;
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       400,
  //       false,
  //       "Please Select at least one business Structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     ParentObjective,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data Found");
  //   }

  //   /** Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Parent Objective",
  //     `Parent Objective updated successfully whose id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = organization.map(async (element) => {
  //     /** Check if this organization already has the particular name */
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM parent_objective WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     /** If record not found for that name with particular organization, insert the record */
  //     if (checkNameWithOrganization.length === 0) {
  //       req.body.created_by = req.user.sessionid;
  //       req.body.organization = element;

  //       const unique_id = await uniqueIdGenerator(
  //         element,
  //         req?.body?.department || null,
  //         "ParentObjective",
  //         "parent_objective",
  //         "unique_id",
  //         "unique_id"
  //       );
  //       req.body.unique_id = unique_id;

  //       const { query, values } = createQueryBuilder(ParentObjective, {
  //         ...req.body,
  //         organization: element,
  //       });

  //       await db.query(query, values);
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   /** Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "create",
  //     "Parent Objective",
  //     `Parent Objective created successfully.`
  //   );

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to get all industry specific skills or specific Parent Objective */
export const getParentObjective = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "parent_objective"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "parent_objective.name",
    "parent_objective.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = parent_objective.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let parentObjectiveQuery = `SELECT 
  parent_objective.*, 
  parent_objective.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM parent_objective
${joinsRecord} 
WHERE parent_objective.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [parentObjective] = await db.query(parentObjectiveQuery);
  parentObjective = await getListingData(parentObjective);
  /**Count all organization */
  const totalRecord = await countQueryCondition(parentObjectiveQuery);
  return sendResponse(res, 200, parentObjective, totalRecord);
  
  
  
  
  
  
  
  
  
  
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "parent_objective",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  // const searchTableName = [
  //   "parent_objective.name",
  //   "parent_objective.description",
  //   "organization.name",
  //   "CONCAT(createdUser.name, ' ', createdUser.surname)",
  // ];

  // /** If value comes with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /** Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users as createdUser",
  //     onCondition: "createdUser.id = parent_objective.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = parent_objective.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // /** Record of all Parent Objectives */
  // const parentObjectiveQuery = `SELECT parent_objective.* , createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id, organization.name as organization_name , createdUser.profile as created_by_profile FROM parent_objective
  //   ${joinsRecord}
  //   WHERE parent_objective.deleted = 0 ${searchCondition} ${condition}`;

  // const [parentObjective] = await db.query(parentObjectiveQuery);

  // for (const parent of parentObjective) {
  //   parent.description = await decodeSingle_statement(parent.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM parent_objective WHERE deleted = 0 AND name = ?`,
  //       [parent.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     parent.organizations = arr;
  //   }
  // }

  // const totalData = await countQueryCondition(parentObjectiveQuery);

  // return sendResponse(res, 200, parentObjective, totalData);
};

/** Function to delete a specific Parent Objective */
export const deleteParentObjective = async (req, res) => {
  const { id } = req.params;

  /** Delete record of organization */
  await deleteSettingRecord("parent_objective", id);

  /** Insert record for activity log */
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Parent Objective",
    `This user deleted Parent Objective which id is ${id}`
  );

  return sendResponse(res, 200, "Record deleted successfully");
};
