import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement, 
    getFirstCreatedAndAllOrganizationIds,
  } from "../helper/general.js";
  import OccupationalDisease from "../sequelize/OccupationalDiseaseSchema.js";
import { createQueryBuilder, updateQueryBuilder } from "../helper/queryBuilder.js";

  /** Function to create or update OccupationalDisease */
  export const createUpdateOccupationalDisease = async (req, res) => {
    const { id, name, description , occupational_disease_type,organization } = req.body;
    
    if (!id) {
      const result = await getFirstCreatedAndAllOrganizationIds();
  
      if (!result.firstOrgId) {
        return sendResponse(res, 404, "No organization found.");
      }
      const unique_id = await uniqueIdGenerator(
        result.firstOrgId,
        req.body?.department || null,
        "OccupationalDisease",
        "occupational_disease",
        "unique_id",
        "unique_id"
      );
      req.body.unique_id = unique_id;
      req.body.organization =
        organization.length > 0 ? organization : result.organizationIds;
    }
    const encodedDescription = await encodeSingle_statement(description);
    req.body.description = encodedDescription;
    req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
    /**If id comes in body then it will update the query */
    const [checkNameWithOrganization] = await getRecord(
      "occupational_disease",
      "name",
      name
    );
    if (checkNameWithOrganization) {
      if (id && checkNameWithOrganization.id != id) {
        return sendResponse(res, 400, "Occupational Disease name already exist");
      } else if (!id) {
        return sendResponse(res, 400, "Occupational Disease name name  already exist");
      }
    }
    if (id) {
      /**Check that this organization have that particular name or not*/
      if (organization.length === 0) {
        return sendResponse(
          res,
          400,
          "Please Select at least one business Structure"
        );
      }
  
      /**update query */
      const { query, values } = updateQueryBuilder(OccupationalDisease, req.body);
      await db.query(query, values);
      /**Update record for activity log */
      await insertActivityLog(req.user.sessionid, "update", "OccupationalDisease", id);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
      const { query, values } = createQueryBuilder(OccupationalDisease, req.body);
      const result = await db.query(query, values);
      /**Insert record for activity log */
      await insertActivityLog(
        req.user.sessionid,
        "create",
        "OccupationalDisease",
        result.insertId
      );
      return sendResponse(res, 200, "Record created successfully");
    }
    
    
    
    
    
    // const encodedDescription = await encodeSingle_statement(description);

    // if (id) {
    //   const result = await settingsUpdater(
    //     OccupationalDisease,
    //     req.body.organization,
    //     req.body,
    //     req.user
    //   );
    //   if (!result) {
    //     return sendResponse(res, 404, "No data found");
    //   }
    //   await insertActivityLog(req.user.sessionid, "update", "OccupationalDisease", `This user updated OccupationalDisease with id: ${id}`);
    //   return sendResponse(res, 200, "Record updated successfully");
    // } else {
    //   const insertPromises = req.body.organization.map(async (org) => {
    //     const [checkName] = await db.query(`SELECT name FROM occupational_disease WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
    //     if (checkName.length === 0) {
    //       await db.query(`INSERT INTO occupational_disease (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
    //       await insertActivityLog(req.user.sessionid, "create", "OccupationalDisease", `This user created a new OccupationalDisease '${name}' for organization ${org}`);
    //     }
    //   });
    //   await Promise.all(insertPromises);
    //   return sendResponse(res, 200, "Record created successfully");
    // }
  };

  /** Function to view all or single OccupationalDisease */
  export const viewOccupationalDisease = async (req, res) => {
    
    let { organizationCondition, condition } = await getFilterConditions(
      req,
      db,
      "occupational_disease"
    );
    /** If value come with any search condition then search that word */
    const searchTableName = [
      "occupational_disease.name",
      "occupational_disease.description",
      "createdUser.name",
    ];
    /** If value come with any search condition then search that word */
    let searchCondition = await searchConditionRecord(
      req.query.search,
      searchTableName
    );
    /**Make Joins according to tables */
    const joins = [
      {
        type: "left",
        targetTable: "users as createdUser",
        onCondition: "createdUser.id = occupational_disease.created_by",
      },
    ];
    const joinsRecord = await makeJoins(joins);
    /**Record of all Skill */
    let occupationalDiseaseQuery = `SELECT 
    occupational_disease.*, 
    occupational_disease.organization AS organizations, 
    createdUser.name AS created_by, 
    createdUser.surname AS created_by_surname, 
    createdUser.id AS created_by_id, 
    createdUser.profile AS created_by_profile
  FROM occupational_disease
  ${joinsRecord} 
  WHERE occupational_disease.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  
    // console.log(skillQuery, "skillQuery");
    let [occupationalDisease] = await db.query(occupationalDiseaseQuery);
    occupationalDisease = await getListingData(documentType);
    /**Count all organization */
    const totalRecord = await countQueryCondition(occupationalDiseaseQuery);
    return sendResponse(res, 200, occupationalDisease, totalRecord);
    
    
    
    
    
    
    
    
    // const { id } = req.params;
    // const condition = await whereCondition({
    //   table: "occupational_disease",
    //   page: req.query.page,
    //   all: req.query.all,
    //   pageSize: req.query.pageSize,
    //   filter: req.query.filter,
    //   id,
    //   user: req.user,
    //   grouped: req.query.grouped,
    // });

    // const searchFields = [
    //   "occupational_disease.name",
    //   "occupational_disease.description",
    //   "users.name",
    //   "organization.name"
    // ];
    // let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    // const joins = [
    //   { type: "left", targetTable: "users", onCondition: "users.id = occupational_disease.created_by" },
    //   { type: "left", targetTable: "organization", onCondition: "organization.id = occupational_disease.organization" }
    // ];
    // const joinsRecord = await makeJoins(joins);

    // const fetchQuery = `SELECT occupational_disease.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM occupational_disease ${joinsRecord} WHERE occupational_disease.deleted = 0 ${searchCondition} ${condition}`;
    // let [records] = await db.query(fetchQuery);

    // for (const record of records) {
    //   record.description = await decodeSingle_statement(record.description);
    //    if (req.query.grouped == "true") {
    //     const [organizations] = await db.query(
    //       `SELECT organization FROM occupational_disease WHERE deleted = 0 AND name = ?`,
    //       [record.name]
    //     );
    //     const arr = organizations.map((item) => item.organization);
    //     record.organizations = arr;
    //   }
    // }

    // const totalRecord = await countQueryCondition(fetchQuery);
    // return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete OccupationalDisease */
  export const deleteOccupationalDisease = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("occupational_disease", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "OccupationalDisease", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };