import db from "../db-config.js";
import {
  makeJoins,
  whereCondition,
  searchConditionRecord,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import Notification from "../sequelize/NotificationSchema.js" // for sync purpose only not to be removed

/**function to get all notification or specific notification */
export const viewAllNotification = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "notification",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "notification.subject",
    "notification.message",
    "organization.name",
    "CONCAT(users.name, ' ', users.surname)",
  ];

  /** If value comes with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = notification.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all notification */
  const notificationQuery = `SELECT notification.is_read,notification.id,notification.user_id,notification.subject,notification.message, notification.created_at, notification.type, notification.created_by, users.name as user_name, users.profile as user_profile , users.surname as user_surname FROM notification
        ${joinsRecord}
        where notification.deleted = 0 ${searchCondition} AND notification.user_id = ${req.user.sessionid} ${condition}`;

  const [notification] = await db.query(notificationQuery);

  /**Count all those notification who is not read from notification bar*/
  const [notificationNotSeen] = await db.query(
    `SELECT COUNT(id) as notSeenNotification FROM notification WHERE on_notification = 1 AND notification.user_id = ${req.user.sessionid}`
  );

  /**Count all those notification who is not read from notification bar*/
  const [notificationNotRead] = await db.query(
    `SELECT COUNT(id) as notReadNotification FROM notification WHERE is_read = 0 AND notification.user_id = ${req.user.sessionid}`
  );

  return res.status(200).json({
    status: true,
    data: notification,
    notSeenNotification: notificationNotSeen[0].notSeenNotification,
    notReadNotification: notificationNotRead[0].notReadNotification,
  });
};
/**Function to read or seen notification  */

export const seenOrReadNotification = async (req, res) => {
  const { id, type, action } = req.body;

  /**if action is read then for read  */
  if (action === "read") {
    if (type == "all") {
      await db.query(
        `UPDATE notification SET is_read = 1 WHERE user_id = ${req.user.sessionid}`
      );
    } else {
      await db.query(
        `UPDATE notification SET is_read = 1 WHERE user_id = ${req.user.sessionid} AND id = ${id}`
      );
    }
  } else {
    await db.query(
      `UPDATE notification SET on_notification = 0 WHERE user_id = ${req.user.sessionid}`
    );
  }

  return sendResponse(res, 200, "Record updated successfully");
};
