import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import Labels from "../sequelize/LabelsSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create new Insurance Policy Impact for employee  */
export const createUpdateLabels = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "LBL",
      "labels",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(Labels, req.body) : createQueryBuilder(Labels, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "Labels", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateLabels = async (req, res) => {
//   const { id, name, description, organization } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   /**If id comes in body then it will update the query */
//   if (id) {
//     if (organization.length === 0) {
//       return sendResponse(
//         res,
//         200,
//         "Please select at least one business structure"
//       );
//     }
//     const result = await settingsUpdater(
//       Labels,
//       organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }

//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Labels",
//       `This user Update Labels which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     /** Insert new record */
//     const insertPromises = organization.map(async (element) => {
//       // Check if the category type already exists for the organization
//       const [checkNameWithOrganization] = await db.query(
//         `SELECT name FROM labels WHERE name = ? AND deleted = "0" AND organization = ?`,
//         [name, element]
//       );

//       // If record not found for that name with particular organization, insert the record
//       if (checkNameWithOrganization.length === 0) {

//           const unique_id = await uniqueIdGenerator(
//             element,
//             req?.body?.department || null,
//             "LBL",
//             "labels",
//             "unique_id",
//             "unique_id"
//           );

//         // Insert Labels details
//         const insertLabelsQuery = `INSERT INTO labels(name, description, created_by, organization,unique_id) VALUES (?, ?,?, ?, ?)`;
//         await db.query(insertLabelsQuery, [
//           name,
//           encodedDescription,
//           req.user.sessionid,
//           element,
//           unique_id
//         ]);

//         // Insert record for activity log
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Labels",
//           `This user created a new category '${name}' for this organization ${element}`
//         );
//       }
//     });

//     await Promise.all(insertPromises);

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all and single Insurance Policy Impact */
export const viewLabels = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "labels");

  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "labels",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchTableName = [
    "labels.name",
    "labels.description",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = labels.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = labels.organization",
    // },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = labels.department",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const labelsQuery = `SELECT labels.*,users.id AS created_by_id, users.name AS created_by, labels.organization AS organizations , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM labels ${joinsRecord} where labels.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // return console.log(
  //   labelsQuery,
  //   "labelsQuery"
  // );
  let [labelsRecord] = await db.query(labelsQuery);

  labelsRecord = await getListingData(labelsRecord);

  // for (const item of labelsRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM labels WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  /**Count all organization */
  const totalRecord = await countQueryCondition(labelsQuery);

  return sendResponse(res, 200, labelsRecord, totalRecord);
};

/**Function to delete a specific Insurance Policy Impact */
export const deleteLabels = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("labels", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Insurance Policy Impact", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
