import asyncHandler from "express-async-handler";
import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  whereCondition,
  settingsUpdater,
  createQueryBuilder,
  searchConditionRecord,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  getFilterConditions,
  getListingData,
  getRecord,
} from "../helper/general.js";
import IssuingAuthority from "../sequelize/IssuingAuthoritySchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create and update Issuing Authority  */
export const createUpdatedIssuingAuthority = async (req, res) => {
  const { id, name,organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(
      res,
      404,
      "Please Select at least one business Structure"
    );
  }

  const [checkNameWithOrganization] = await getRecord(
    "issuing_authority",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Issuing Authority name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Issuing Authority name already exist");
    }
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "IssuingAuthority",
      "issuing_authority",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(IssuingAuthority, req.body)
    : createQueryBuilder(IssuingAuthority, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(
    req.user.sessionid,
    status,
    "IssuingAuthority",
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record ${status} Successfully`);
};

/**Function to view all Issuing Authority */
export const viewAllIssuingAuthority = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "issuing_authority"
  );

  // const condition = await whereCondition({
  //   table: "issuing_authority",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id: req.params.id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  /** If value come with any search condition then search that word */
  const searchTableName = [
    "issuing_authority.name",
    "issuing_authority.description",
    "createdUser.name",
  ];
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = issuing_authority.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = issuing_authority.organization",
    // },
  ];
  const joinsRecord = await makeJoins(joins);

  /**Record of all alert */
  const issuingAuthorityDataFetchQuery = `SELECT issuing_authority.unique_id, issuing_authority.id,issuing_authority.created_by as created_by_id,issuing_authority.name,issuing_authority.description,createdUser.name as created_by ,createdUser.surname as created_by_surname ,createdUser.profile as created_by_profile ,issuing_authority.organization as organizations,issuing_authority.organization
    FROM issuing_authority  
    ${joinsRecord} 
    where issuing_authority.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  let [issuingAuthorityDataFetch] = await db.query(
    issuingAuthorityDataFetchQuery
  );

  issuingAuthorityDataFetch = await getListingData(issuingAuthorityDataFetch);

  // for (const item of issuingAuthorityDataFetch) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM issuing_authority WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  /**Count all Issuing Authority */
  const totalRecord = await countQueryCondition(issuingAuthorityDataFetchQuery);

  return sendResponse(res, 200, issuingAuthorityDataFetch, totalRecord);
};

/**Function to delete a specific Issuing Authority */
export const deleteIssuingAuthority = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("issuing_authority", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    insertActivityLog(req.user.sessionid, "delete", "Issuing Authority", id);
    return res.status(200).json({
      status: true,
      message: "Record deleted successfully",
    });
  }
};
