import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  settingsUpdater,
  uniqueIdGenerator,
  getRecord,
  getFirstCreatedAndAllOrganizationIds,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import Gender from "../sequelize/GenderSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update Gender */
export const createUpdateGender = async (req, res) => {
  const { id, name, description, organization } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();
    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Gender",
      "gender",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  
  const [checkNameWithOrganization] = await getRecord("gender", "name", name);
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Gender name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Gender name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(Gender, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "Gender", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(Gender, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Gender",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(
  //     Gender,
  //     req.body.organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Gender",
  //     `This user updated Gender with id: ${id}`
  //   );
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(
  //       `SELECT name FROM gender WHERE name = ? AND deleted = 0 AND organization = ?`,
  //       [name, org]
  //     );
  //     if (checkName.length === 0) {
  //       let unique_id;
  //       if (!id) {
  //         unique_id = await uniqueIdGenerator(
  //           org,
  //           req.body?.department || null,
  //           "Gender",
  //           "gender",
  //           "unique_id",
  //           "unique_id"
  //         );
  //       }

  //       await db.query(
  //         `INSERT INTO gender (name, description, created_by, organization,unique_id) VALUES (?, ?, ?, ?,?)`,
  //         [name, encodedDescription, req.user.sessionid, org, unique_id]
  //       );
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Gender",
  //         `This user created a new Gender '${name}' for organization ${org}`
  //       );
  //     }
  //   });
  //   await Promise.all(insertPromises);
  // return sendResponse(res, 200, "Record created successfully");
};

/** Function to view all or single Gender */
export const viewGender = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "gender"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "gender.name",
    "gender.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = gender.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let genderQuery = `SELECT 
  gender.*, 
  gender.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM gender
${joinsRecord} 
WHERE gender.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [genders] = await db.query(genderQuery);
  genders = await getListingData(genders);
  /**Count all organization */
  const totalRecord = await countQueryCondition(genderQuery);
  return sendResponse(res, 200, genders, totalRecord);

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "gender",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "gender.name",
  //   "gender.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = gender.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = gender.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT gender.*, users.name AS created_by, users.surname as created_by_surname, organization.name AS organization_name FROM gender ${joinsRecord} WHERE gender.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM gender WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete Gender */
export const deleteGender = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("gender", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "Gender", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
