import {
  countQueryCondition,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteRecord,
  encodeSingle_statement,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import db from "../db-config.js";
import { createQueryBuilder } from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";
import EnvironmentalIncident from "../sequelize/EnvironmentalIncidentTechnicalFormSchema.js";

/**Function to create Environment Incident Form  */
export const createEnvironmentalIncidentsForm = async (req, res) => {
  const { id } = req.body;
  const sessionId = req.user.sessionid;
  let organizationId = req.body.organization;
  const { department, comments } = req.body;

  if (department) {
    const recordAccordingToOrganization =
      await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0]?.organization;
    if (organizationId) {
      req.body.organization = organizationId;
    }
  }

  req.body.created_by = sessionId;
  // req.body.incident_date = JSON.stringify(req.body.incident_date);
  console.log("req.body: ", req.body);
  const { query, values } = id
    ? updateQueryBuilder(EnvironmentalIncident, req.body)
    : createQueryBuilder(EnvironmentalIncident, req.body);

  let [createEnvironmentalForm] = await db.query(query, values);
  if (!id && createEnvironmentalForm.insertId == 0) {
    return sendResponse(res, 404, "Cannot create record");
  }

  await insertActivityLog(
    req.user.sessionid,
    "create",
    "Environmental Incident Technical Form",
    `This user created a new environment incident technical Form Record for organization ${organizationId}`
  );

  return sendResponse(res, 200, "Record created successfully");
};

export const getEnvironmentalIncidentsForm = async (req, res) => {
  const { type } = req.query;
  const { id } = req.params;
  const condition = await whereCondition({
    table: "environmental_incidents",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
    columnName: type,
  });
  const searchTableName = [
    "environmental_incidents.save_type",
    "environmental_incidents.incident_name",
    "environmental_incidents.initial_incident_severity",
    "environmental_incidents.incident_category",
    "environmental_incidents.incident_description",
    "environmental_incidents.incident_location",
    "environmental_incidents.environmental_incident_description",
    "organization.name",
    "department.name",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = environmental_incidents.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = environmental_incidents.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = environmental_incidents.department",
    },
    {
      type: "left",
      targetTable: "incident_category",
      onCondition: "incident_category.id = environmental_incidents.category_id",
    },
  ];
  const joinCondition = await makeJoins(joins);
  const environmentalIncidentsFormQuery = `SELECT environmental_incidents.* , organization.name as organization_name ,department.name as department_name , users.name as created_by_name , users.surname as created_by_surname  , users.profile as created_by_profile , incident_category.name as category_name FROM environmental_incidents ${joinCondition} WHERE environmental_incidents.deleted = 0 ${condition} ${searchCondition}`;

  const totalRecord = await countQueryCondition(
    environmentalIncidentsFormQuery
  );

  let [environmentalIncidentForm] = await db.query(
    environmentalIncidentsFormQuery
  );
  environmentalIncidentForm = await decodeAndParseFields(
    environmentalIncidentForm
  );
  for (const data of environmentalIncidentForm) {
    if (data.reported_by) {
      const [userFetch] = await db.query(
        `SELECT CONCAT(users.name , ' ' , users.surname) as name , profile FROM users WHERE id = '${Number(
          data.reported_by
        )}'`
      );
      data.reported_by_name = userFetch[0].name;
      data.reported_by_profile = userFetch[0].profile;
    }
    data.comments = await decodeSingle_statement(data.comments);
  }
  return sendResponse(res, 200, environmentalIncidentForm, totalRecord);
};

export const deleteEnvironmentalIncidentsForm = async (req, res) => {
  const { id } = req.params;
  const deleteForm = await deleteRecord("environmental_incidents", id);
  if (deleteForm) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Environmental Incidents Form",
      `This user deleted a new Environment incidents Form Record for organization ${id}`
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
  return sendResponse(res, 404, "Cannot delete record");
};
