import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement, 
    uniqueIdGenerator,
  } from "../helper/general.js";
  import DeviationCategory from "../sequelize/DeviationCategorySchema.js";

  /** Function to create or update DeviationCategory */
  export const createUpdateDeviationCategory = async (req, res) => {
    const { id, name, description } = req.body;
    const encodedDescription = await encodeSingle_statement(description);

    if (id) {
      const result = await settingsUpdater(
        DeviationCategory,
        req.body.organization,
        req.body,
        req.user
      );
      if (!result) {
        return sendResponse(res, 404, "No data found");
      }
      await insertActivityLog(req.user.sessionid, "update", "DeviationCategory", `This user updated DeviationCategory with id: ${id}`);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
      const insertPromises = req.body.organization.map(async (org) => {
        const [checkName] = await db.query(`SELECT name FROM deviation_category WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
        if (checkName.length === 0) {
          const unique_id = await uniqueIdGenerator(
            org,
            req.body?.department,
            "DECT",
            "deviation_category",
            "unique_id",
            "unique_id"
          );
          await db.query(`INSERT INTO deviation_category (name, description, created_by, organization,unique_id) VALUES (?, ?,?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
          await insertActivityLog(req.user.sessionid, "create", "DeviationCategory", `This user created a new DeviationCategory '${name}' for organization ${org}`);
        }
      });
      await Promise.all(insertPromises);
      return sendResponse(res, 200, "Record created successfully");
    }
  };

  /** Function to view all or single DeviationCategory */
  export const viewDeviationCategory = async (req, res) => {
    const { id } = req.params;
    const condition = await whereCondition({
      table: "deviation_category",
      page: req.query.page,
      all: req.query.all,
      pageSize: req.query.pageSize,
      filter: req.query.filter,
      id,
      user: req.user,
      grouped: req.query.grouped,
    });

    const searchFields = [
      "deviation_category.name",
      "deviation_category.description",
      "users.name",
      "organization.name"
    ];
    let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    const joins = [
      { type: "left", targetTable: "users", onCondition: "users.id = deviation_category.created_by" },
      { type: "left", targetTable: "organization", onCondition: "organization.id = deviation_category.organization" }
    ];
    const joinsRecord = await makeJoins(joins);

    const fetchQuery = `SELECT deviation_category.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM deviation_category ${joinsRecord} WHERE deviation_category.deleted = 0 ${searchCondition} ${condition}`;
    let [records] = await db.query(fetchQuery);

    for (const record of records) {
      record.description = await decodeSingle_statement(record.description);
       if (req.query.grouped == "true") {
        const [organizations] = await db.query(
          `SELECT organization FROM deviation_category WHERE deleted = 0 AND name = ?`,
          [record.name]
        );
        const arr = organizations.map((item) => item.organization);
        record.organizations = arr;
      }
    }

    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete DeviationCategory */
  export const deleteDeviationCategory = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("deviation_category", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "DeviationCategory", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };