import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import Banks from "../sequelize/BanksSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { createQueryBuilder, updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create new Banks for employee  */
export const createUpdateBanks = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Bank",
      "banks",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(Banks, req.body) : createQueryBuilder(Banks, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "Banks", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateBanks = async (req, res) => {
//   const { id, name, description, organization } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   /**If id comes in body then it will update the query */
//   if (id) {
//     if (organization.length === 0) {
//       return sendResponse(
//         res,
//         200,
//         "Please select at least one business structure"
//       );
//     }
//     const result = await settingsUpdater(
//       Banks,
//       organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }

//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "Banks",
//       `This user Update Banks which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     /** Insert new record */
//     const insertPromises = organization.map(async (element) => {
//       // Check if the category type already exists for the organization
//       const [checkNameWithOrganization] = await db.query(
//         `SELECT name FROM banks WHERE name = ? AND deleted = "0" AND organization = ?`,
//         [name, element]
//       );

//       // If record not found for that name with particular organization, insert the record
//       if (checkNameWithOrganization.length === 0) {
//         // Insert Banks details
//          const unique_id = await uniqueIdGenerator(
//             element,
//             req.body?.department || null,
//             "Bank",
//             "banks",
//             "unique_id",
//             "unique_id"
//           );

//         const insertBanksQuery = `INSERT INTO banks(name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`;
//         await db.query(insertBanksQuery, [
//           name,
//           encodedDescription,
//           req.user.sessionid,
//           element,
//           unique_id
//         ]);

//         // Insert record for activity log
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "Banks",
//           `This user created a new category '${name}' for this organization ${element}`
//         );
//       }
//     });

//     await Promise.all(insertPromises);

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all and single Banks */
export const viewBanks = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "banks");

  const searchTableName = [
    "banks.name",
    "banks.description",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = banks.created_by",
    },

    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = banks.department",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const BanksQuery = `SELECT banks.*,users.id AS created_by_id, users.name AS created_by, banks.organization AS organizations , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM banks ${joinsRecord} where banks.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  let [BanksRecord] = await db.query(BanksQuery);

  BanksRecord = await getListingData(BanksRecord);

  /**Count all organization */
  const totalRecord = await countQueryCondition(BanksQuery);

  return sendResponse(res, 200, BanksRecord, totalRecord);
};

/**Function to delete a specific Banks */
export const deleteBanks = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("banks", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Banks", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
